#include <stdio.h>
#include <stdlib.h>


int main(int argc, char **argv)
{
  FILE *fp;
  char tmp[128];
  float f, last_f = 1000.0;
  long t;

  if(argc < 2) {
    printf("Find time in log-file, where temperature differs more than 0.5 degrees between two consecutive readings.\n");
    printf("Usage: %s <file>\n", argv[0]);
    exit(0);
  }

  fp = fopen(argv[1], "r");
  
  while(!feof(fp)) {
    fgets(tmp, 100, fp);
    if(sscanf(tmp, "%ld: %f", &t, &f) == 2) {
      if(last_f == 1000.0) last_f = f;
      if((f - last_f) > 0.5) {
	printf("big diff: %ld %f  (%f)\n", t, f, (f - last_f));
      }
      last_f = f;
    } else {
      printf("new section: [%s]\n", tmp);
    }
  }
  exit(0);
}

