
#include "db_mini.h"

int
__db_truncate(dbp, txn, countp, flags)
     DB *dbp;
     DB_TXN *txn;
     u_int32_t *countp, flags;
{
  struct db_ent *ent, *entp;
  if(!dbp) return -1;
  if(!dbp->head) return -1;

#ifdef CACHE_DEBUG
  printf("db_truncate:\n");
#endif
    
  db_lock(dbp);
  entp = dbp->head;
  ent = dbp->head->next;
  while(ent) {
    if(ent->key) {
      if(ent->key->data) free(ent->key->data);
      free(ent->key);
    }
    if(ent->val) {
      if(ent->val->data) free(ent->val->data);
      free(ent->val);
    }
    entp = ent;
    ent = ent->next;
    free(entp);
  }

  memset(dbp->head, 0, sizeof(struct db_ent));
  //dbp->tail = NULL;
  db_unlock(dbp);
  return 0;
}
