
#include "db_mini.h"

int
__db_put(dbp, txn, key, val, flags)
     DB *dbp;
     DB_TXN *txn;
     DBT *key;
     DBT *val;
     u_int32_t flags;
{
  DBT *k;
  struct db_ent *ent, *entp;
  if(!dbp) return -1;
  if(!dbp->head) return -1;
  if(!key) return -1;
  if(!key->data) return -1;
  if(!val) return -1;
  if(!val->data) return -1;

#ifdef CACHE_DEBUG
  {
    char tmp[80];
    memcpy(tmp, key->data, key->size); 
    tmp[key->size] = '\0';
    printf("db_put: key=%s\n", tmp);
    memcpy(tmp, val->data, val->size); 
    tmp[val->size] = '\0';
    printf("db_put: val=%s\n", tmp);
  }
#endif

  db_lock(dbp);
  entp = dbp->head;
  ent = dbp->head->next;

  while(ent) {
    k = ent->key;
    if(k && (k->size == key->size) &&
       !memcmp(k->data, key->data, k->size)) {
      /* found same key in list, replace it */
      if(ent->val) {
	if(ent->val->data) free(ent->val->data);
      } else {
	ent->val = malloc(sizeof(DBT));
      }
      ent->val->data = malloc(val->size);
      memcpy(ent->val->data, val->data, val->size);
      ent->val->size = val->size;
#ifdef CACHE_DEBUG
      printf("db_put: reuse old entry\n");
#endif
      db_unlock(dbp);
      return 0;
    }
    entp = ent;
    ent = ent->next;
  }

  entp->next = malloc(sizeof(struct db_ent));
  ent = entp->next;
  ent->next = NULL;

  ent->key = malloc(sizeof(DBT));
  ent->key->data = malloc(key->size);
  memcpy(ent->key->data, key->data, key->size);
  ent->key->size = key->size;

  ent->val = malloc(sizeof(DBT));
  ent->val->data = malloc(val->size);
  memcpy(ent->val->data, val->data, val->size);
  ent->val->size = val->size;
  db_unlock(dbp);
  return 0;
}
