
#include "db_mini.h"

int
__db_get(dbp, txn, key, val, flags)
     DB *dbp;
     DB_TXN *txn;
     DBT *key;
     DBT *val;
     u_int32_t flags;
{
  DBT *k, *v;
  struct db_ent *ent;
  if(!dbp) return -1;
  if(!dbp->head) return -1;
  if(!key) return -1;
  if(!key->data) return -1;
  if(!val) return -1;

#ifdef CACHE_DEBUG
  {
    char tmp[80];
    memcpy(tmp, key->data, key->size);
    tmp[key->size] = '\0';
    printf("db_get: key=%s\n", tmp);
  }
#endif

  db_lock(dbp);
  
  ent = dbp->head->next;
  while(ent) {
    k = ent->key;
    if(k && (k->size == key->size) &&
       !memcmp(k->data, key->data, k->size)) {
      v = ent->val;
      val->data = v->data;
      val->size = v->size;
#ifdef CACHE_DEBUG
      {
	char tmp[80];
	memcpy(tmp, val->data, val->size);
	tmp[val->size] = '\0';
	printf("db_get: found value=%s\n", tmp);
      }
#endif
      db_unlock(dbp);
      return 0;
    }
    ent = ent->next;
  }
  db_unlock(dbp);
  return 1;
}
