
#include "db_mini.h"

int
__db_del(dbp, txn, key, flags)
     DB *dbp;
     DB_TXN *txn;
     DBT *key;
     u_int32_t flags;
{
  DBT *k, *v;
  struct db_ent *ent, *entp;
  if(!dbp) return 0;
  if(!dbp->head) return 0;

#ifdef CACHE_DEBUG
  {
    char tmp[80];
    memcpy(tmp, key->data, key->size);
    tmp[key->size] = '\0';
    printf("db_del: key=%s\n", tmp);
  }
#endif
  
  db_lock(dbp);
  
  entp = dbp->head;
  ent = dbp->head->next;
  while(ent) {
    k = ent->key;
    if(k && (k->size == key->size) &&
       !memcmp(k->data, key->data, k->size)) {

      if(k->data) free(k->data);
      free(k);

      v = ent->val;
      if(v) {
	if(v->data) free(v->data);
	free(v);
      }
      entp->next = ent->next;
      free(ent);
      db_unlock(dbp);
      return 0;
    }
    entp = ent;
    ent = ent->next;
  }
  db_unlock(dbp);
  return 1;
}
