
#include "db_mini.h"
#ifdef USE_PTHREAD
#include <pthread.h>
#endif

int
db_create(dbp, env, flags)
     DB **dbp;
     DB_ENV *env;
     u_int32_t flags;
{
  DB *db;

#ifdef CACHE_DEBUG
  printf("db_create:\n");
#endif

  db = malloc(sizeof(DB));
  if(!db) return -1;

  memset(db, 0, sizeof(DB));

  db->head = malloc(sizeof(struct db_ent));
  if(!db->head) {
    free(db);
    return -1;
  }
  memset(db->head, 0, sizeof(struct db_ent));

  db->open = __db_open;
  db->close = __db_close;
  db->del = __db_del;
  db->get = __db_get;
  db->put = __db_put;
  db->truncate = __db_truncate;

#ifdef USE_PTHREAD
  {
      pthread_mutexattr_t attr;
      pthread_mutexattr_init(&attr);
      pthread_mutexattr_settype(&attr, PTHREAD_MUTEX_ADAPTIVE_NP);
      pthread_mutex_init(&db->db_mutex, &attr);
      pthread_mutexattr_destroy(&attr);
  }
#endif

  //db->tail = NULL;
  *dbp = db;
  return 0;
}
