
#include "db_mini.h"
#ifdef USE_PTHREAD
#include <pthread.h>
#endif

int
__db_close(dbp, flags)
     DB *dbp;
     u_int32_t flags;
{
  if(!dbp) return -1;

#ifdef CACHE_DEBUG
  printf("db_close:\n");
#endif

  dbp->truncate(dbp, NULL, NULL, 0);

#ifdef USE_PTHREAD
  pthread_mutex_destroy(&dbp->db_mutex);
#endif

  free(dbp->head);
  free(dbp);
  return 0;
}
