#ifndef _DB_MINI_H_
#define _DB_MINI_H_

#define USE_PTHREAD

#include <sys/types.h>
#include <inttypes.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifdef USE_PTHREAD
#include <pthread.h>
#endif

#define DB_VERSION_MAJOR        4
#define DB_VERSION_MINOR        2
#define DB_VERSION_PATCH        1
#define DB_VERSION_STRING       "db_mini 1.0.3: (March  23, 2004)"


#if defined(__cplusplus)
extern "C" {
#endif

#undef __P
#define __P(protos)     protos

  typedef u_int32_t       db_pgno_t;      /* Page number type. */
  typedef u_int16_t       db_indx_t;      /* Page offset type. */
  
  struct __db_mini;            typedef struct __db_mini DB;
  struct __db_mini_txn;        typedef struct __db_mini_txn DB_TXN;
  struct __db_mini_dbt;        typedef struct __db_mini_dbt DBT;
  struct __db_mini_env;        typedef struct __db_mini_env DB_ENV;

  struct __db_mini_txn {
  };

  struct __db_mini_env {
  };

  struct __db_mini_dbt {
    void     *data;                 /* Key/data */
    u_int32_t size;                 /* key/data length */
  };

  typedef enum {
    DB_BTREE=1,
    DB_HASH=2,
    DB_RECNO=3,
    DB_QUEUE=4,
    DB_UNKNOWN=5                    /* Figure it out on open. */
  } DBTYPE;

#define DB_CREATE             0x0000001 /* Create file as necessary. */
#define DB_THREAD             0x0000040 /* Applications are threaded. */

#define DB_NOSYNC               23      /* close() */


  struct db_ent {
    DBT *key;
    DBT *val;
    //struct db_ent *prev;
    struct db_ent *next;
  };

  char *db_version __P((int *, int *, int *));
  int db_create __P((DB **, DB_ENV *, u_int32_t));
  char *db_strerror __P((int));
  void db_lock __P((DB *));
  void db_unlock __P((DB *));
  
  struct __db_mini {
    struct db_ent *head;
    //struct db_ent *tail;
#ifdef USE_PTHREAD
    pthread_mutex_t db_mutex;
#endif
    
    int  (*close) __P((DB *, u_int32_t));
    int  (*del) __P((DB *, DB_TXN *, DBT *, u_int32_t));
    int  (*get) __P((DB *, DB_TXN *, DBT *, DBT *, u_int32_t));
    int  (*open) __P((DB *, DB_TXN *,
		      const char *, const char *, DBTYPE, u_int32_t, int));
    int  (*put) __P((DB *, DB_TXN *, DBT *, DBT *, u_int32_t));
    int  (*truncate) __P((DB *, DB_TXN *, u_int32_t *, u_int32_t));
  };

#if defined(__cplusplus)
}
#else
int  __db_close __P((DB *, u_int32_t));
int  __db_del __P((DB *, DB_TXN *, DBT *, u_int32_t));
int  __db_get __P((DB *, DB_TXN *, DBT *, DBT *, u_int32_t));
int  __db_open __P((DB *, DB_TXN *,
		  const char *, const char *, DBTYPE, u_int32_t, int));
int  __db_put __P((DB *, DB_TXN *, DBT *, DBT *, u_int32_t));
int  __db_truncate __P((DB *, DB_TXN *, u_int32_t *, u_int32_t));
#endif
#endif /* _DB_MINI_H_ */
