/*
 * $Id: html.c,v 1.10 2008/01/04 16:07:48 d1mag Exp $
 *
 * temploggerd -- graph/log utility written for OWFS
 * Written 2005 Christian Magnusson
 * email: mag@mag.cx
 * Released under the GPL
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include <errno.h>

#include <globals.h>
#include <rrdfile.h>
#include <sensor.h>
#include <util.h>
#include <html.h>

int html_var_nr = 0;
int html_var_color = 0;
int inside_sensor_loop = 0;
int inside_rrdfile_loop = 0;
char unknown_sensor[] = "(unknown sensor)";
extern int print_rrd_commands;

char *colors[24];
void initiate_colors()
{
  int x;
  for(x=0; x<24; x++) {
    unsigned long idx;
    int i = x%24;
    //printf("x=%d i=%d", x, i);
    if(i<8) {
      // Seem to be a bug in rrdcgi, so totally black doesn't work
      idx = 0x000001L;
      if(i & 0x04) idx += 0x0000F0;
      if(i & 0x02) idx += 0x00F000;
      if(i & 0x01) idx += 0xD00000;
      if(i == 7) idx = 0xD0D0D0 ;  // avoid too white for 7th color
    } else {
      idx = 0x6F6F6FL;
      for(i-=8; i>0; i-=8) {
	if(i & 0x04) idx += 0x00003F;
	if(i & 0x02) idx += 0x003F00;
	if(i & 0x01) idx += 0x3F0000;
      }
    }
    if(!(colors[x] = malloc(10))) exit(1);
    sprintf(colors[x], "#%06lX", (idx & 0xFFFFFFL));
    if(print_rrd_commands) printf("Default color %2d: %s\n", x, colors[x]);
  }
  return;
}

static char html_color[10];
char *get_html_color(int x)
{
  int i = x%24;
  sprintf(html_color, "%s", colors[i]);
  return html_color;
}

int append_fwrite(const char *out_file, const char *tmp, size_t sz, size_t nr_memb, FILE *out)
{
  int rc;
  FILE *fp = fopen(out_file, "a+");
  (void) out;
  if(!fp) {
    printf("Error appending to [%s]", out_file);
    return -1;
  }
  rc = fwrite(tmp, sz, nr_memb, fp);
  fclose(fp);
  return rc;
}

/*
  Reading a template-file and replaces all tags
*/
int replace_tags(char *out_file, FILE *out, struct sensor *cur_sensor, char *tmpl_file, FILE *fp, struct rrd_file *cur_rrdfile)
{
  char tmp[ROW_LEN+1];
  char *inbuf = NULL;
  size_t inbuf_len;
  size_t sz;
  int search_endtag;
  char varname[ROW_LEN+1];
  char *s;
  int need_close = 0;
  char *out_file_copy = NULL;
  FILE *out_copy = NULL;
  int row = 0;
  int html_tag_row = -1;
  if(!cur_sensor) cur_sensor = sensors;

  //printf("replace_tags\n");

  if(!fp) {
    //printf("Replace tags in [%s]\n", tmpl_file);
    fp = fopen(tmpl_file, "r");
    if(!fp) {
      printf("Error open [%s]\n", tmpl_file);
      return -1;
    }
    need_close = 1;
  }

  search_endtag = 0;
  inbuf_len = 0;
  while(!feof(fp)) {
    if(inbuf_len == 0) {
      if(!(inbuf = fgets(tmp, ROW_LEN, fp))) break;
      inbuf_len = strlen(tmp);
      row++;;
    }

    if(inside_sensor_loop) {
      // all data should be saved to temp-file until end tag
      if(search_endtag) {
	if((s = strstr(inbuf, "-->"))) {
	  if((html_tag_row == row) && (sscanf(inbuf+4, "%s", varname) == 1)) {
	    //printf("Found varname inside loop [%s]\n", varname);

	    if(!strcasecmp(varname, "rrdfile_loop_start")) {
	      printf("Warning: rrdfile_loop_start found inside sensor_loop");
	      goto sensor_ignore_tag;
	    } else if(!strcasecmp(varname, "rrdfile_loop_end")) {
	      printf("Warning: rrdfile_loop_end found inside sensor_loop");
	      goto sensor_ignore_tag;
	    }  else if(!strcasecmp(varname, "sensor_loop_end")) {
	      FILE *fp1;
	      //printf("Found sensor_loop_end\n");
	      
	      inside_sensor_loop = 0;
	      rrdfile_output = INSIDE_SENSOR_LOOP;

	      // restore to save html to real file.
	      out = out_copy;
	      out_file = out_file_copy;
	      
	      cur_sensor = sensors;
	      while(cur_sensor) {
		if(save_all_sensors) {
		  if(cur_sensor->ignored) {
		    cur_sensor = cur_sensor->next;
		    continue;
		  }
		} else {
		  if(cur_sensor->ignored || !cur_sensor->file_found_on_bus) {
		    cur_sensor = cur_sensor->next;
		    continue;
		  }
		}
		if(cur_rrdfile && (cur_sensor->rrdfile != cur_rrdfile)) {
		  cur_sensor = cur_sensor->next;
		  continue;
		}

		fp1 = fopen(tmp_file, "r");
		if(!fp1) {
		  printf("Error: reading temp-file! [%s]\n", tmp_file);
		  exit(0);
		}
		/* recursive call */
		if(replace_tags(out_file, out, cur_sensor, tmp_file, fp1, cur_rrdfile) < 0) {
		  printf("Error replace tags inside loop\n");
		  exit(0);
		}
		fclose(fp1);
		//printf("sensor loop end %p %p\n", cur_sensor, cur_sensor->next);
		cur_sensor = cur_sensor->next;
	      }

	      rrdfile_output = OUTSIDE_LOOP;

	      inbuf_len = 0;
	      search_endtag = 0;
	    } else {
	      // It was not the end-tag... Just save it to tmp_file
	    sensor_ignore_tag:
	      sz = (unsigned long)s - (unsigned long)inbuf + 3;
	      append_fwrite(out_file, inbuf, sz, 1, out);
	      inbuf_len -= sz;
	      inbuf += sz;
	      search_endtag = 0;
	    }
	  } else {
	    printf("save since Error stop-tag: [%s]\n", inbuf);
	    append_fwrite(out_file, inbuf, inbuf_len, 1, out);
	    //search_endtag = 0;
	    inbuf_len = 0;
	  }
	} else {
	  printf("save since just text: [%s]\n", inbuf);
	  append_fwrite(out_file, inbuf, inbuf_len, 1, out);
	  //search_endtag = 0;
	  inbuf_len = 0;
	}
      } else {
	if((s = strstr(inbuf, "<!--"))) {
	  html_tag_row = row;
	  search_endtag = 1;
	  if(s > inbuf) {
	    sz = (unsigned long)s - (unsigned long)inbuf;
	    append_fwrite(out_file, inbuf, sz, 1, out);
	    inbuf = s;
	    inbuf_len -= sz;
	  }
	} else {
	  append_fwrite(out_file, inbuf, inbuf_len, 1, out);
	  inbuf_len = 0;
	}
      }
      continue;
    }

    if(inside_rrdfile_loop) {
      // all data should be saved to temp-file until end tag
      if(search_endtag) {
	if((s = strstr(inbuf, "-->"))) {
	  if((html_tag_row == row) && (sscanf(inbuf+4, "%s", varname) == 1)) {
	    //printf("Found varname inside loop [%s]\n", varname);

	    if(!strcasecmp(varname, "sensor_loop_start")) {
	      //printf("Warning: sensor_loop_start found inside rrdfile_loop");
	      goto rrd_igore_tag;
	    } else if(!strcasecmp(varname, "sensor_loop_end")) {
	      printf("Warning: sensor_loop_end found inside rrdfile_loop");
	      goto rrd_igore_tag;
	    } else if(!strcasecmp(varname, "rrdfile_loop_end")) {
	      FILE *fp1;
	      //printf("Found rrdfile_loop_end\n");
      
	      inside_rrdfile_loop = 0;
	      rrdfile_output = INSIDE_RRDFILE_LOOP;

	      // restore to save html to real file.
	      out = out_copy;
	      out_file = out_file_copy;
	      
	      cur_rrdfile = rrd_files;
	      cur_sensor = sensors;
	      while(cur_rrdfile) {
		if(cur_rrdfile->nr_sensors == 0) {
		  cur_rrdfile = cur_rrdfile->next;
		  continue;
		}
		fp1 = fopen(tmp_file, "r");
		if(!fp1) {
		  printf("Error: reading temp-file! [%s]\n", tmp_file);
		  exit(0);
		}
		/* recursive call */
		if(replace_tags(out_file, out, cur_sensor, tmp_file, fp1, cur_rrdfile) < 0) {
		  printf("Error replace tags inside loop\n");
		  exit(0);
		}
		fclose(fp1);
		//printf("rrdfile loop end %p %p\n", cur_rrdfile, cur_rrdfile->next);
		cur_rrdfile = cur_rrdfile->next;
	      }

	      rrdfile_output = OUTSIDE_LOOP;

	      inbuf_len = 0;
	      search_endtag = 0;
	    } else {
	      // It was not the end-tag... Just save it to tmp_file
	    rrd_igore_tag:
	      sz = (unsigned long)s - (unsigned long)inbuf + 3;
	      append_fwrite(out_file, inbuf, sz, 1, out);
	      inbuf_len -= sz;
	      inbuf += sz;
	      search_endtag = 0;
	    }
	  } else {
	    printf("save since Error stop-tag: [%s]\n", inbuf);
	    append_fwrite(out_file, inbuf, inbuf_len, 1, out);
	    //search_endtag = 0;
	    inbuf_len = 0;
	  }
	} else {
	  printf("save since just text: [%s]\n", inbuf);
	  append_fwrite(out_file, inbuf, inbuf_len, 1, out);
	  //search_endtag = 0;
	  inbuf_len = 0;
	}
      } else {
	if((s = strstr(inbuf, "<!--"))) {
	  html_tag_row = row;
	  search_endtag = 1;
	  if(s > inbuf) {
	    sz = (unsigned long)s - (unsigned long)inbuf;
	    append_fwrite(out_file, inbuf, sz, 1, out);
	    inbuf = s;
	    inbuf_len -= sz;
	  }
	} else {
	  append_fwrite(out_file, inbuf, inbuf_len, 1, out);
	  inbuf_len = 0;
	}
      }
      continue;
    }

    if(search_endtag) {
      if((s = strstr(inbuf, "-->"))) {
	if((html_tag_row == row) && (sscanf(inbuf+4, "%s", varname) == 1)) {
	  //printf("Found varname [%s]\n", varname);
	  if(!strcasecmp(varname, "rrdcgi_file")) {
	    append_fwrite(out_file, rrdcgi_file, strlen(rrdcgi_file), 1, out);
	  } else if(!strcasecmp(varname, "rrdfile_path")) {
	    append_fwrite(out_file, rrdfile_path, strlen(rrdfile_path), 1, out);
	  } else if(!strcasecmp(varname, "rrdfile_default")) {
	    append_fwrite(out_file, rrdfile_default, strlen(rrdfile_default), 1, out);
	  } else if(!strcasecmp(varname, "rrdtool")) {
	    append_fwrite(out_file, rrdtool, strlen(rrdtool), 1, out);
	  } else if(!strcasecmp(varname, "rrdimg_path")) {
	    append_fwrite(out_file, rrdimg_path, strlen(rrdimg_path), 1, out);
	  } else if(!strcasecmp(varname, "images_path")) {
	    append_fwrite(out_file, images_path, strlen(images_path), 1, out);
	  } else if(!strcasecmp(varname, "cgi_path")) {
	    append_fwrite(out_file, cgi_path, strlen(cgi_path), 1, out);
	  } else if(!strcasecmp(varname, "www_dir")) {
	    append_fwrite(out_file, www_dir, strlen(www_dir), 1, out);
	  } else if(!strcasecmp(varname, "base_dir")) {
	    append_fwrite(out_file, base_dir, strlen(base_dir), 1, out);
	  } else if(!strcasecmp(varname, "cgi_dir")) {
	    append_fwrite(out_file, cgi_dir, strlen(cgi_dir), 1, out);
	  } else if(!strcasecmp(varname, "$nr=0")) {
	    html_var_nr = 0;
	  } else if(!strcasecmp(varname, "$nr++")) {
	    html_var_nr++;
	  } else if(!strcasecmp(varname, "$nr")) {
	    char nr_[20];
	    sprintf(nr_, "%d", html_var_nr);
	    append_fwrite(out_file, nr_, strlen(nr_), 1, out);
	  } else if(!strcasecmp(varname, "$color=0")) {
	    html_var_color = 0;
	  } else if(!strcasecmp(varname, "rrdfile_loop_end")) {
	    printf("Warning: rrdfile_loop_end without any rrdloop_loop_start\n");
	  } else if(!strcasecmp(varname, "rrdfile_description")) {
	    if(rrdfile_output == INSIDE_RRDFILE_LOOP) {
	      //printf("inside rrdfile_loop\n");
	      /* inside rrdfile_loop */
	      if(cur_rrdfile) {
		//printf("rrdfile = %s\n", cur_rrdfile->description);
		append_fwrite(out_file, cur_rrdfile->description, strlen(cur_rrdfile->description), 1, out);
	      } else {
		printf("this shouldn't happen: cur_rrdfile==NULL inside loop\n");
		exit(0);
	      }
	    } else if(rrdfile_output == INSIDE_SENSOR_LOOP) {
	      //printf("inside sensor_loop\n");
	      if(cur_sensor) {
		if(cur_sensor->rrdfile) {
		  //printf("rrdfile = %s\n", cur_sensor->rrdfile->description);
		  append_fwrite(out_file, cur_sensor->rrdfile->description, strlen(cur_sensor->rrdfile->description), 1, out);
		} else {
		  printf("this shouldn't happen: cur_sensor->rrdfile_==NULL\n");
		  exit(0);
		}
	      } else {
		printf("this shouldn't happen: cur_sensor==NULL inside loop\n");
		exit(0);
	      }
	    } else {
	      /* OUTSIDE_LOOP should always come here */
	      if(cur_rrdfile) {
		append_fwrite(out_file, cur_rrdfile->description, strlen(cur_rrdfile->description), 1, out);
	      } else {
		append_fwrite(out_file, rrdfile_description_default, strlen(rrdfile_description_default), 1, out);
	      }
	    }
	  } else if(!strcasecmp(varname, "rrdfile")) {
	    if(rrdfile_output == INSIDE_RRDFILE_LOOP) {
	      //printf("inside rrdfile_loop\n");
	      /* inside rrdfile_loop */
	      if(cur_rrdfile) {
		//printf("rrdfile = %s\n", cur_rrdfile->name);
		append_fwrite(out_file, cur_rrdfile->name, strlen(cur_rrdfile->name), 1, out);
	      } else {
		printf("this shouldn't happen: cur_rrdfile==NULL inside loop\n");
		exit(0);
	      }
	    } else if((rrdfile_output == INSIDE_SENSOR_LOOP)) {
	      //printf("inside sensor_loop\n");
	      if(cur_sensor) {
		if(cur_sensor->rrdfile) {
		  //printf("rrdfile = %s\n", cur_sensor->rrdfile->name);
		  append_fwrite(out_file, cur_sensor->rrdfile->name, strlen(cur_sensor->rrdfile->name), 1, out);
		} else {
		  printf("this shouldn't happen: cur_sensor->rrdfile_==NULL\n");
		  exit(0);
		}
	      } else {
		printf("this shouldn't happen: cur_sensor==NULL inside loop??\n");
		exit(0);
	      }
	    } else {
	      /* OUTSIDE_LOOP should always come here */
	      if(cur_rrdfile) {
		append_fwrite(out_file, cur_rrdfile->name, strlen(cur_rrdfile->name), 1, out);
	      } else {
		append_fwrite(out_file, rrdfile_default, strlen(rrdfile_default), 1, out);
	      }
	    }
	  } else if(!strcasecmp(varname, "$color=sensor")) {
	    if(cur_sensor) {
	      struct sensor *ss;
	      //html_var_color = cur_sensor->column;
	      html_var_color = 0;
	      ss = sensors;
	      while(ss) {
		if(ss == cur_sensor) break;
		if(save_all_sensors) {
		  if(ss->ignored) {
		    ss = ss->next;
		    continue;
		  }
		} else {
		  if(ss->ignored || !ss->file_found_on_bus) {
		    ss = ss->next;
		    continue;
		  }
		}
		if(cur_rrdfile && (ss->rrdfile != cur_rrdfile)) {
		  ss = ss->next;
		  continue;
		}
		html_var_color++;
		ss = ss->next;
	      }
	    } else {
	      append_fwrite(out_file, unknown_sensor, strlen(unknown_sensor), 1, out);
	    }
	  } else if(!strcasecmp(varname, "$color++")) {
	    html_var_color++;
	  } else if(!strcasecmp(varname, "$color")) {
	    char col[20];
	    if(cur_sensor && cur_sensor->color[0]) {
	      sprintf(col, "%s", cur_sensor->color);
	    } else {
	      sprintf(col, "%s", get_html_color(html_var_color));
	    }
	    append_fwrite(out_file, col, strlen(col), 1, out);
	  } else if(!strcasecmp(varname, "next_sensor")) {
	    if(cur_sensor) {
	      cur_sensor = cur_sensor->next;
	    } else {
	      append_fwrite(out_file, "(no more sensors)", strlen("(no more sensors)"), 1, out);
	    }
	  } else if(!strcasecmp(varname, "location")) {
	    if(cur_sensor) {
	      append_fwrite(out_file, cur_sensor->location, strlen(cur_sensor->location), 1, out);
	    } else {
	      append_fwrite(out_file, unknown_sensor, strlen(unknown_sensor), 1, out);
	    }
	  } else if(!strcasecmp(varname, "_location")) {
	    char loc[LOCATION_LEN+1];
	    if(cur_sensor) {
	      replace_space_dot(cur_sensor->location, loc);
	      append_fwrite(out_file, loc, strlen(loc), 1, out);
	    } else {
	      append_fwrite(out_file, unknown_sensor, strlen(unknown_sensor), 1, out);
	    }
	  } else if(!strcasecmp(varname, "_sensid")) {
	    char id_[DEVICE_ID_LEN+1];
	    if(cur_sensor) {
	      replace_space_dot(cur_sensor->id, id_);
	      append_fwrite(out_file, id_, strlen(id_), 1, out);
	    } else {
	      append_fwrite(out_file, unknown_sensor, strlen(unknown_sensor), 1, out);
	    }
	  } else if(!strcasecmp(varname, "rrd_sensid")) {
	    char rrdid[FILENAME_LEN+1];
	    if(cur_sensor) {
	      rrd_sensid(cur_sensor, rrdid);
	      append_fwrite(out_file, rrdid, strlen(rrdid), 1, out);
	    } else {
	      append_fwrite(out_file, unknown_sensor, strlen(unknown_sensor), 1, out);
	    }
	  } else if(!strcasecmp(varname, "datafile_full")) {
	    if(cur_sensor) {
	      char datafile_without_slash[FILENAME_LEN+1];
	      replace_slash(cur_sensor->datafile, datafile_without_slash);
	      append_fwrite(out_file, datafile_without_slash, strlen(datafile_without_slash), 1, out);
	    } else {
	      append_fwrite(out_file, unknown_sensor, strlen(unknown_sensor), 1, out);
	    }
	  } else if(!strcasecmp(varname, "datafile")) {
	    /* The basename of the datafile */
	    char datafile[FILENAME_LEN+1];
	    char *lastslash;
	    if(cur_sensor) {
	      strcpy(datafile, cur_sensor->datafile);
	      if((lastslash = strrchr(datafile, '/')) == NULL)
		lastslash = datafile;
	      else
		lastslash = &lastslash[1];
	      append_fwrite(out_file, lastslash, strlen(lastslash), 1, out);
	    } else {
	      append_fwrite(out_file, unknown_sensor, strlen(unknown_sensor), 1, out);
	    }
	  } else if(!strcasecmp(varname, "_datafile")) {
	    char datafile[FILENAME_LEN+1];
	    if(cur_sensor) {
	      replace_space(cur_sensor->datafile, datafile);
	      append_fwrite(out_file, datafile, strlen(datafile), 1, out);
	    } else {
	      append_fwrite(out_file, unknown_sensor, strlen(unknown_sensor), 1, out);
	    }
	  } else if(!strcasecmp(varname, "sensid")) {
	    if(cur_sensor) {
	      append_fwrite(out_file, cur_sensor->id, strlen(cur_sensor->id), 1, out);
	    } else {
	      append_fwrite(out_file, unknown_sensor, strlen(unknown_sensor), 1, out);
	    }
	  } else if(!strcasecmp(varname, "rrdfile_loop_end")) {
	    printf("Warning: rrdfile_loop_end without any rrdfile_loop_start\n");
	  } else if(!strcasecmp(varname, "sensor_loop_end")) {
	    printf("Warning: sensor_loop_end without any sensor_loop_start\n");
	  } else if(!strcasecmp(varname, "sensor_loop_start")) {
	    //printf("found sensor_loop_start\n");
	    if(inside_sensor_loop) {
	      printf("Error: sensor_loop_start found inside loop!\n");
	      exit(0);
	    }
	    inside_sensor_loop = 1;
	    // Leave cur_rrdfile in sensor-loop as it is
	    cur_sensor = sensors;  // loop from first sensor

	    out_file_copy = out_file;
	    out_copy = out;

	    out_file = tmp_file;
	    out = fopen(out_file, "w");
	    if(!out) {
	      printf("Error creating new temp-file [%s]\n", out_file);
	      exit(0);
	    }
	    fclose(out);

	    //printf("new out = %p\n", out);
	  } else if(!strcasecmp(varname, "rrdfile_loop_start")) {
	    //printf("found rrdfile_loop_start\n");
	    if(inside_rrdfile_loop) {
	      printf("Error: rrdfile_loop_start found inside loop!\n");
	      exit(0);
	    }
	    inside_rrdfile_loop = 1;
	    cur_sensor = NULL;    // no specific senser in rrd-loop
	    cur_rrdfile = rrd_files;  // loop from first rrd_file

	    out_file_copy = out_file;
	    out_copy = out;

	    out_file = tmp_file;
	    out = fopen(out_file, "w");
	    if(!out) {
	      printf("Error creating new temp-file [%s]\n", out_file);
	      exit(0);
	    }
	    fclose(out);

	    //printf("new out = %p\n", out);
	  } else {
	    /* Unknown tag? Just save it */
	    printf("Unknown tag [%s] in [%s]\n", varname, tmpl_file);
	    sz = (unsigned long)s - (unsigned long)inbuf + 3;
	    append_fwrite(out_file, inbuf, sz, 1, out);
	  }
	  sz = (unsigned long)s - (unsigned long)inbuf + 3;
	} else {
	  //printf("sscanf failed on [%s]\n", inbuf);
	  sz = (unsigned long)s - (unsigned long)inbuf + 3;
	  append_fwrite(out_file, inbuf, sz, 1, out);
	}
	inbuf_len -= sz;
	inbuf += sz;
	search_endtag = 0;
      } else {
	append_fwrite(out_file, inbuf, inbuf_len, 1, out);
	inbuf_len = 0;
      }
    } else {
      if((s = strstr(inbuf, "<!--"))) {
	search_endtag = 1;
	html_tag_row = row;
	if(s > inbuf) {
	  sz = (unsigned long)s - (unsigned long)inbuf;
	  append_fwrite(out_file, inbuf, sz, 1, out);
	  inbuf = s;
	  inbuf_len -= sz;
	}
      } else {
	append_fwrite(out_file, inbuf, inbuf_len, 1, out);
	inbuf_len = 0;
      }
    }
  }

  if(need_close) fclose(fp);
  return 0;
}

int create_webpage_sensor(struct sensor *s)
{
  FILE *fp = NULL;
  char file[FILENAME_LEN+1];
  char tmpl[FILENAME_LEN+1];

  if(!s) return 0;
  
  if(!s->datafile || !s->rrdfile) return 0;

  if(s->datafile[0] == '/') {
    char datafile[FILENAME_LEN+1];
    char *ptr;
    replace_space(s->datafile, datafile);
    if((ptr = strrchr(datafile, '/')) == NULL) {
      ptr = datafile;
    } else {
      ptr = &ptr[1];
    }
    sprintf(file, "%s%s.%s.cgi", cgi_dir, s->id, ptr);
  } else {
    char datafile_without_slash[FILENAME_LEN+1];
    replace_slash(s->datafile, datafile_without_slash);
    sprintf(file, "%s%s.%s.cgi", cgi_dir, s->id, datafile_without_slash);
  }
  if(s->ignored) {
    //printf("%s is ignored. don't create [%s]\n", s->id, file);
    return 0;
  }
  //printf("create %s\n", file);

  fp = fopen(file, "w");
  if(!fp) {
    printf("Error: Can't write to file %s\n", file);
    exit(0);
  }
  fclose(fp);

  //printf("replacing tags from [%s] to [%s] (rrdfile=%s)\n", s->rrdfile->tmpl_sensor, file, s->rrdfile->name);
  sprintf(tmpl, "%s/%s", tmpl_dir, s->rrdfile->tmpl_sensor);
  if(replace_tags(file, NULL, s, tmpl, NULL, s->rrdfile) < 0) {
    printf("Error: Can't replace tags from [%s] to [%s] (rrdfile=%s)\n", s->rrdfile->tmpl_sensor, file, s->rrdfile->name);
    exit(0);
  }

  if(chmod(file, 0755) < 0) {
    printf("Error chmod [%s]\n", file);
  }
  return 0;
}

#define BUF_SIZE 8192
int copy_images_dir(void)
{
  FILE *fp = NULL;
  FILE *fp2 = NULL;
  struct dirent **namelist;
  struct stat st;
  size_t sz;
  int n;
  int left;
  char tmp[BUF_SIZE];
  char src_path[FILENAME_LEN+1];
  char dest_path[FILENAME_LEN+1];
  char src_file[FILENAME_LEN+1];
  char dest_file[FILENAME_LEN+1];

  sprintf(src_path, "%s/", images_dir);
  sprintf(dest_path, "%s/%s/%s", www_dir, base_dir, images_path);

  if(stat(src_path, &st) < 0) {
    printf("Warning: image-dir doesn't exist at [%s]\n", src_path);
    return 0;
  }

  if(stat(dest_path, &st) < 0) {
    printf("Warning: Creating image-dir at [%s]\n", dest_path);
    if(mkdir(dest_path, 0777) < 0) {
      printf("Error creating directory [%s]\n", dest_path);
      return 0;
    }
  }

  if((n = scandir(src_path, &namelist, 0, alphasort)) < 0) {
    printf("copy_images_dir: [%s] %s\n", src_path, strerror(errno));
    return 0;
  }
  while(n--) {
    sprintf(tmp, "%s/%s", src_path, namelist[n]->d_name);
    if((stat(tmp, &st) < 0) || !S_ISREG(st.st_mode)) {
      //printf("skip [%s]\n", namelist[n]->d_name);
      free(namelist[n]);
      namelist[n] = NULL;
      continue;
    }
    left = st.st_size;

    sprintf(dest_file, "%s/%s", dest_path, namelist[n]->d_name);
    if(!(fp2 = fopen(dest_file, "w"))) {
      printf("Error write file [%s]\n", dest_file);
      goto next_file;
    }

    sprintf(src_file, "%s/%s", src_path, namelist[n]->d_name);
    if(!(fp = fopen(src_file, "r"))) {
      printf("Error open file [%s]\n", src_file);
      goto next_file;
    }
    //printf("Copy [%s] -> [%s]\n", src_file, dest_file);
    while(!feof(fp)) {
      sz = fread(tmp, 1, (size_t)((left>BUF_SIZE) ? BUF_SIZE : left), fp);
      if(sz > 0) {
	left -= sz;
	if(!fwrite(tmp, sz, 1, fp2)) break;
      } else {
	break;
      }
    }

  next_file:
    if(fp) fclose(fp);
    fp = NULL;
    if(fp2) fclose(fp2);
    fp2 = NULL;
    free(namelist[n]);
    namelist[n] = NULL;
  }
  free(namelist);
  namelist = NULL;
  return 0;
}

int create_webpage_index(void)
{
  FILE *fp = NULL;
  struct rrd_file *r;
  int i;
  char file[FILENAME_LEN+1];
  char tmpl[FILENAME_LEN+1];

  sprintf(file, "%sall.cgi", cgi_dir);
  fp = fopen(file, "w");
  if(!fp) {
    printf("error truncate %s", file);
    exit(0);
  }
  fclose(fp);
  sprintf(tmpl, "%s/%s", tmpl_dir, tmpl_all_cgi);
  if(replace_tags(file, NULL, NULL, tmpl, NULL, NULL) < 0) {
    printf("Error replacing tags from [%s] to [%s]\n", tmpl_all_cgi, file);
    exit(0);
  }

  if(chmod(file, 0755) < 0) {
    printf("Error chmod [%s]\n", file);
  }

  /**************************/

  r = rrd_files;
  while(r) {
    if(!save_all_sensors && (r->nr_sensors==0)) {
      r = r->next;
      continue;
    }
    sprintf(file, "%sall.%s.cgi", cgi_dir, r->name);
    //printf("create page %s\n", file);
    if(!(fp = fopen(file, "w"))) {
      printf("Error truncate %s", file);
      exit(0);
    }
    fclose(fp);
    sprintf(tmpl, "%s/%s", tmpl_dir, r->tmpl_all);
    if(replace_tags(file, NULL, NULL, tmpl, NULL, r) < 0) {
      printf("Error replacing tags from [%s] to [%s]\n", r->tmpl_all, file);
      exit(0);
    }
    
    if(chmod(file, 0755) < 0) {
      printf("Error chmod [%s]\n", file);
    }
    r = r->next;
  }

  /* Copy all template files and replace tags */
  if(tmpl_files) {
    i = 0;
    while(tmpl_files[i]) {
      sprintf(file, "%s%s/%s", www_dir, base_dir, tmpl_files[i]);
      if(!(fp = fopen(file, "w"))) {
	printf("Error truncate %s\n", file);
	exit(0);
      }
      fclose(fp);
      sprintf(tmpl, "%s/%s", tmpl_dir, tmpl_files[i]);
      if(!(fp = fopen(tmpl, "r"))) {
	printf("Error reading template %s\n", tmpl);
	exit(0);
      }
      fclose(fp);
      if(replace_tags(file, NULL, NULL, tmpl, NULL, NULL) < 0) {
	printf("Error replacing tags from [%s] to [%s]\n", tmpl, file);
	exit(0);
      }
      i++;
    }
  }

  return 0;
}

