/*
 * $Id: globals.h,v 1.5 2007/08/02 21:05:22 d1mag Exp $
 *
 * temploggerd -- graph/log utility written for OWFS
 * Written 2005 Christian Magnusson
 * email: mag@mag.cx
 * Released under the GPL
*/
#ifndef GLOBALS_H
#define GLOBALS_H

#include <config.h>

#define MAX_ERRORS 5

#define FILENAME_LEN 128
#define FLOAT_LEN 12
#define FOUR_FLOAT_LEN (4*FLOAT_LEN+3)
#define DEVID_LEN 15

/* The html-templates are read row by row, and this is the
 * maximum allowed row-length... Change this later...
 */
#define ROW_LEN 512

#define LOCATION_LEN 80
#define DEVICE_ID_LEN 15
#define COLOR_LEN 10


/* All config variables are defined as global variables...
 * Not very nice, but change it later.
 */

extern char owfs_dir[FILENAME_LEN+1];
extern char www_dir[FILENAME_LEN+1];
extern char base_dir[FILENAME_LEN+1];
extern char rrdfile_path[FILENAME_LEN+1];
extern char rrdfile_default[FILENAME_LEN+1];
extern char rrdfile_description_default[FILENAME_LEN+1];
extern char rrdcgi_file[FILENAME_LEN+1];
extern char rrdtool[FILENAME_LEN+1];
extern char rrdimg_path[FILENAME_LEN+1];
extern char images_path[FILENAME_LEN+1];
extern char cgi_dir[FILENAME_LEN+1];
extern char cgi_path[FILENAME_LEN+1];
extern char backup_dir[FILENAME_LEN+1];
extern char backup_freq[FILENAME_LEN+1];
extern int _backup_freq;
extern char tmp_file[FILENAME_LEN+1];
extern char config_file[FILENAME_LEN+1];
extern char images_dir[FILENAME_LEN+1];
extern char tmpl_dir[FILENAME_LEN+1];
extern char tmpl_all_cgi[FILENAME_LEN+1];
extern char tmpl_all_default[FILENAME_LEN+1];
extern char tmpl_sensor_default[FILENAME_LEN+1];
extern char add_new_sensor_script[FILENAME_LEN+1];
extern char **tmpl_files;

extern unsigned char save_all_sensors;


#endif
