/*
 * $Id: simultaneous.c,v 1.2 2005/08/26 17:51:44 d1mag Exp $
 *
 * temploggerd -- graph/log utility written for OWFS
 * Written 2005 Christian Magnusson
 * email: mag@mag.cx
 * Released under the GPL
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <globals.h>
#include <simultaneous.h>

#ifndef IGNORE_SIMULTANEOUS

struct simultaneous *simultaneous_files = NULL;

struct simultaneous *add_simultaneous(char *path)
{
  struct simultaneous *ss, *s = simultaneous_files;
  while(s) {
    if(!strcmp(s->path, path)) {
      /* found the simultaneous-file... */
      break;
    }
    s = s->next;
  }
  if(!s) {
    s = (struct simultaneous *)malloc(sizeof(struct simultaneous));
    if(!s) {
      printf("Error: allocate struct simultaneous\n");
      return NULL;
    }
    memset(s, 0, sizeof(struct simultaneous));
    strncpy(s->path, path, FILENAME_LEN);
    s->path[FILENAME_LEN+1] = '\000';
    
    if(!simultaneous_files) {
      simultaneous_files = s;
    } else {
      ss = simultaneous_files;
      while(ss->next) {
	ss = ss->next;
      }
      ss->next = s;
    }
  }
  return s;
}

#endif
