#!/bin/sh
# 
# Attempt to strip comments and pod docs from perl modules
#

[ "$#" -gt 0 ] || set .
echo "---> Stripping modules in: $@" >&2
find "$@" -name \*.pm -or -name \*.pl -or -name \*.pod | while read fn; do
	echo "   $fn" >&2
	sed -e '/^=\(head\|pod\|item\|over\|back\)/,/^=cut/d; /^=\(head\|pod\|item\|over\|back\)/,$d; /^#$/d; /^#[^!"'"'"']/d' \
		< "$fn" > "$fn.new"
	#mv -f "$fn" "$fn.bak"
	mv -f "$fn.new" "$fn"
done
