#!/bin/sh
#
# Split Perl installation into modules and build IPKG package
# control files and Makefile for them.
#
# TODO:
#  * Better modules split
#  * Track dependencies
#  * Config -> essential?
#

# --- config ---

rdir="/home/frol/openwrt/WR-RC4/OpenWrt-SDK-Linux-i686-1/build_mipsel/perl/perl-5.8.7/ipkg-install"
libdir="usr/lib/perl5/5.8"
arch=mipsel
ver="5.8.7"

skipfiles="CORE|vmsish.pm|auto/sdbm|getopt.pl|getopts.pl|utf8_heavy.pl|newgetopt.pl|dbm_filter_util.pl|open[23].pl|Config_heavy.pl|lib.pm|vars.pm|strict.pm|warnings*|Carp*|Exporter*|locale.pm|subs.pm|bytes_heavy.pl|overload.pm|constant.pm"

special="essential:lib.pm,vars.pm,strict.pm,warnings.pm,warnings,Carp,Carp.pm,Exporter,Exporter.pm,locale.pm,subs.pm,overload.pm,constant.pm
	getoptpl:getopt.pl,getopts.pl
	utf8:utf8_heavy.pl
	Getopt:newgetopt.pl
	DBM_Filter:dbm_filter_util.pl
	open:open2.pl,open3.pl
	Config:Config_heavy.pl
	bytes:bytes_heavy.pl"

# XXX don't yet
depends="IO-Handle:Symbol,SelectSaver
	IO:XSLoader
	IO-Socket:Socket
	Errno:Config
	POSIX:AutoLoader"

# --- end config ---

cwd=`pwd`
cd "$rdir/$libdir"

for path in * auto/*; do
	eval "case \"$path\" in
		$skipfiles|auto|*/auto|pod) continue;; esac"

	mod=`basename $path | sed 's/\.p[ml]//'`
	var=`echo $mod | tr a-z- A-Z_`
	eval "${var}_files=\"\$${var}_files $path\"; ${var}_mod=$mod"

	case " $packages " in
	*" $var "*) ;;
	*) packages="$packages $var"; echo "found module $mod" >&2;;
	esac
done

for sp in $special; do
	mod="${sp%%:*}"
	var=`echo $mod | tr a-z- A-Z_`
	files=`echo "${sp##*:}" | tr , ' '`
	eval "${var}_files=\"\$${var}_files $files\";
		[ \"\$${var}_mod\" ] || ${var}_mod=\"$mod\""

	case " $packages " in
	*" $var "*) ;;
	*) packages="$packages $var"; echo "special module $mod" >&2;;
	esac
done

echo "removing old control files" >&2
rm -f "$cwd"/ipkg/perlbase-*.control

echo "writing Makefile.modules" >&2
exec 3> "$cwd/Makefile.modules"

for var in $packages; do
	name=`echo $var | tr A-Z_ a-z-`
	eval "files=\"\$${var}_files\"; mod=\$${var}_mod"

	echo "writing ipkg/perlbase-$name.control" >&2
	cat <<EOT > "$cwd/ipkg/perlbase-$name.control"
Package: perlbase-$name
Priority: optional
Section: lang
Version: $ver
Architecture: $arch
Maintainer: Dmitry Frolov <frol@nov.net>
Source: http://www.cpan.org/
Description: $mod perl module
Depends: perl
EOT

	echo "\$(eval \$(call ipkg_pm,PERLBASE_$var,perlbase-$name,$files,perl))" >&3
done
