/*
 * $Id: util.c,v 1.3 2007/12/29 08:21:21 d1mag Exp $
 *
 * temploggerd -- graph/log utility written for OWFS
 * Written 2005 Christian Magnusson
 * email: mag@mag.cx
 * Released under the GPL
*/

#include <stdio.h>
#include <string.h>
#include <time.h>
#include <errno.h>

#include <util.h>

int replace_space(char *s, char *d)
{
  while(*s) {
    if(*s == ' ') {
      *d++ = '_';
      s++;
    } else {
      *d++ = *s++;
    }
  }
  *d++ = '\000';
  return 0;
}

int replace_space_dot(char *s, char *d)
{
  while(*s) {
    if(*s == ' ' || *s == '.') {
      *d++ = '_';
      s++;
    } else {
      *d++ = *s++;
    }
  }
  *d++ = '\000';
  return 0;
}

int remove_space(char *s, char *d)
{
  while(*s) {
    if((*s == ' ') || (*s == '.') || (*s == '_')) {
      s++;
    } else {
      *d++ = *s++;
    }
  }
  *d++ = '\000';
  return 0;
}

unsigned char char2hex(char x)
{
  if((x>='0') && (x<='9')) return x-'0';
  if((x>='a') && (x<='f')) return 10+x-'a';
  if((x>='A') && (x<='F')) return 10+x-'A';
  return 0;
}      

void my_delay(unsigned long ms)
{
  struct timespec ts;
  struct timespec rem;

  rem.tv_sec = ms / 1000;
  rem.tv_nsec = 1000000*(ms%1000);
  while(1) {
    ts.tv_sec = rem.tv_sec;
    ts.tv_nsec = rem.tv_nsec;
    if(nanosleep(&ts, &rem) < 0) {
      if(errno == EINTR) {
	/* was interupted... continue sleeping... */
      } else {
	printf("my_delay: error? %s\n", strerror(errno));
	return;
      }
    } else {
      /* completed sleeping */
      return;
    }
  }
}



#if 0
void timeval_add_ms(struct timeval *res, struct timeval *tv, unsigned long ms)
{
  //printf("timeval_add_ms()\n");
  if(!res) return;
  res->tv_sec = tv->tv_sec;
  res->tv_usec = tv->tv_usec;
  
  res->tv_usec += ms*1000;
  while(res->tv_usec >= 1000000) {
    res->tv_usec -= 1000000;
    res->tv_sec++;
  }
  return;
}

void timeval_add(struct timeval *res, struct timeval *tv1, struct timeval *tv2)
{
  //printf("timeval_add()\n");
  if(!res) return;
  res->tv_sec = tv1->tv_sec + tv2->tv_sec;
  res->tv_usec = tv1->tv_usec + tv2->tv_usec;
  
  while(res->tv_usec >= 1000000) {
    res->tv_usec -= 1000000;
    res->tv_sec++;
  }
  return;
}

int timeval_diff(struct timeval *diff,
		 struct timeval *tv1, struct timeval *tv2)
{
  /*
   * tv1 should be greater or equal to tv2
   *    returns 1 if tv1 > tv2
   *    returns 0 if tv1 == tv2
   *
   *    returns -1 if tv1 < tv2
   */
  int res = 0;
  //printf("timeval_diff()\n");

  if(tv1->tv_sec > tv2->tv_sec) res = 1;
  else if(tv1->tv_sec < tv2->tv_sec) res = -1;
  else {
    if(tv1->tv_usec > tv2->tv_usec) res = 1;
    else if(tv1->tv_usec < tv2->tv_usec) res = -1;
    else res = 0;
  }
  if(diff == NULL) return res;

  if(res == 0) {
    diff->tv_sec = 0;
    diff->tv_usec = 0;
  } else if(res == 1) {
    diff->tv_sec = tv1->tv_sec - tv2->tv_sec;
    diff->tv_usec = tv1->tv_usec - tv2->tv_usec;
    if(diff->tv_usec < 0) {
      diff->tv_usec += 1000000;
      diff->tv_sec--;
    }
  } else if(res == -1) {
    diff->tv_sec = tv2->tv_sec - tv1->tv_sec;
    diff->tv_usec = tv2->tv_usec - tv1->tv_usec;
    if(diff->tv_usec < 0) {
      diff->tv_usec += 1000000;
      diff->tv_sec--;
    }
  }
  return res;
}

unsigned long timeval2ms(struct timeval *tv)
{
  unsigned long d;
  d = (tv->tv_sec & 0x003FFFFF) * 1000 + tv->tv_usec / 1000;
  /*
    3FFFFFh == 4194303,
    1000*4194303 == 4194303000 == 48.5 days difference max
  */
  return d;
}
#endif
