/*
 * $Id: rrdfile.c,v 1.2 2005/08/26 17:51:44 d1mag Exp $
 *
 * temploggerd -- graph/log utility written for OWFS
 * Written 2005 Christian Magnusson
 * email: mag@mag.cx
 * Released under the GPL
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <globals.h>
#include <rrdfile.h>

#ifndef IGNORE_RRDFILE

struct rrd_file *rrd_files = NULL;

enum rrdfile_state rrdfile_output = OUTSIDE_LOOP;

struct rrd_file *add_rrdfile(char *name, char *tmpl_all, char *tmpl_sensor, char *description)
{
  struct rrd_file *rr, *r = rrd_files;
  while(r) {
    if(!strcmp(r->name, name)) {
      /* found the rrd-file... just set attributes */
      break;
    }
    r = r->next;
  }
  if(!r) {
    r = (struct rrd_file *)malloc(sizeof(struct rrd_file));
    if(!r) {
      printf("Error: allocate struct rrd_file\n");
      return NULL;
    }
    memset(r, 0, sizeof(struct rrd_file));
    strncpy(r->name, name, FILENAME_LEN);
    r->name[FILENAME_LEN+1] = '\000';
    
    if(!rrd_files) {
      rrd_files = r;
    } else {
      rr = rrd_files;
      while(rr->next) {
	rr = rr->next;
      }
      rr->next = r;
    }
  }
  if(tmpl_all) {
    strcpy(r->tmpl_all, tmpl_all);
  }
  if(tmpl_sensor) {
    strcpy(r->tmpl_sensor, tmpl_sensor);
  }
  if(description) {
    strcpy(r->description, description);
  }
  return r;
}

struct rrd_ds *find_rrd_ds(struct rrd_file *r, char *name)
{
  struct rrd_ds *ds;
  if(!r) return NULL;
  ds = r->ds;
  while(ds) {
    if(!strcmp(ds->name, name)) break;
    ds = ds->next;
  }
  return ds;
}

struct rrd_ds *add_rrd_ds(struct rrd_file *r, char *name, int exists)
{
  struct rrd_ds *ds;
  if(!r) return NULL;

  if((ds = find_rrd_ds(r, name))) {
    if(exists) ds->exists = exists;
    return ds;
  }

  ds = malloc(sizeof(struct rrd_ds));
  memset(ds, 0, sizeof(struct rrd_ds));
  strcpy(ds->name, name);

  if(!r->ds) {
    r->ds = ds;
  } else {
    ds->next = r->ds;
    r->ds = ds;
  }
  return ds;
}

void cleanup_rrd_ds(struct rrd_file *r)
{
  struct rrd_ds *ds;
  if(!r) return;

  while(r->ds) {
    ds = r->ds->next;
    free(r->ds);
    r->ds = ds;
  }
}

void free_rrd_ds(struct rrd_file *r, char *name)
{
  struct rrd_ds *ds, *dspre;
  if(!r) return;

  dspre = NULL;
  ds = r->ds;
  while(ds) {
    if(!strcmp(ds->name, name)) {
      if(dspre) {
	dspre->next = ds->next;
      } else {
	r->ds = ds->next;
      }
      free(ds);
      return;
    }
    dspre = ds;
    ds = ds->next;
  }
}

int read_rrd_file(struct rrd_file *r) {
  FILE *fp;
  char cmd[FILENAME_LEN+1];
  char *t;
  char tmp[ROW_LEN+1];
  char name[ROW_LEN+1];
  char last_name[ROW_LEN+1];
  int len;
  char *s, *s2;

  last_name[0] = '\000';

  sprintf(cmd, "%s info %s/%s", rrdtool, rrdfile_path, r->name);
  if(!(fp = popen(cmd, "r"))) {
    printf("read_rrd_file: error popen()\n");
    return -1;
  }
  while(!feof(fp)) {
    if(!(t = fgets(tmp, ROW_LEN, fp))) {
      break;
    }
    if(!strncmp(tmp, "ds[", 3) && (s = strchr(tmp, '[')) && (s2 = strchr(s, ']'))) {
      len = (unsigned long)s2 - (unsigned long)s - 1;
      strncpy(name, &s[1], len); 
      name[len] = '\000';
      if(strcmp(last_name, name)) {
	// new datasource
	if(add_rrd_ds(r, name, 1)) {
	  // new ds added
	  //printf("%s added to %s\n", name, r->name);
	} else {
	  //printf("Failed to add %s to %s\n", name, r->name);
	}
	strcpy(last_name, name);
      }
    }
  }
  pclose(fp);
  return 0;
}

#endif
