#!/bin/bash
#
# add a new temperature sensor /10.123456789012/temperature
# rrd-name should in this case be "10123456789012tempe"

TMPDIR=/tmp

#SENSORNAME=10123456789012tempe

if [ -z "$1" ]; then
    echo "Enter the name of the sensor to add as an argument to this script"
    echo "The sensor name should be 19 characters! (without dots or spaces)"
    echo "Example: Adding sensor /10.123456789012/temperature "
    echo ""
    echo "   add_new_sensor.sh 10123456789012tempe [/path/file.rrd]"
    exit 1
fi
SENSORNAME=$1

if [ -z "$2" ]; then
    RRDFILE=/var/www/html/temploggerd/rrd/temperature.rrd
    echo "Using default rrd-file [${RRDFILE}]"
else
    RRDFILE="$2"
fi
RRDDIR=`dirname ${RRDFILE}`


if [ ! -f ${RRDFILE} ]; then
    echo "Error: RRD-file doesn't exist. Update path in this script."
    exit 1
fi

if [ ! -d ${RRDDIR} ]; then
    echo "Error: RRD-directory doesn't exist. Update path in this script."
    exit 1
fi

rrdtool dump ${RRDFILE} > ${TMPDIR}/temperature.xml
STATUS=$?
if [ ! $STATUS -eq 0 ]; then
    echo "Error: 'rrdtool dump' seem to exit with an error"
    exit 1
fi

rrd_replace -a -i ${TMPDIR}/temperature.xml -o ${TMPDIR}/temperature.xml.new -c ${SENSORNAME}
STATUS=$?
if [ ! $STATUS -eq 0 ]; then
    echo "Error: rrd_replace seem to exit with an error"
    exit 1
fi

rm -f ${TMPDIR}/temperature.xml

if [ ! -f ${TMPDIR}/temperature.xml.new ]; then
    echo "Error: New xml-file wasn't created"
    exit 1
fi

rm -f ${RRDFILE}.new
rrdtool restore ${TMPDIR}/temperature.xml.new ${RRDFILE}.new
STATUS=$?
if [ ! $STATUS -eq 0 ]; then
    echo "Error: 'rrdtool restore' seem to exit with an error"
    exit 1
fi

rm -f ${TMPDIR}/temperature.xml.new

if [ -s ${RRDFILE}.new ]; then
    cp ${RRDFILE} ${RRDFILE}.backup
    mv ${RRDFILE}.new ${RRDFILE}
fi

exit 0
